/*
 *
 *  Copyright (C) 2010-2011 Amr Thabet <amr.thabet@student.alx.edu.eg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to Amr Thabet 
 *  amr.thabet@student.alx.edu.eg
 *
 */
typedef struct PEXCEPTION_REGISTRATION_RECORD
{
     PEXCEPTION_REGISTRATION_RECORD* Next;
     dword Handler;
};

typedef struct TIB
{
     PEXCEPTION_REGISTRATION_RECORD* ExceptionList;  //FS:[0x00]
     dword StackBase;                               //FS:[0x04]
     dword StackLimit;                              //FS:[0x08]
     dword SubSystemTib;                            //FS:[0x0C]
     dword FiberData;                               //FS:[0x10]
     dword ArbitraryUserPointer;                    //FS:[0x14]
     dword TIB;                                     //FS:[0x18]
};
struct PEB;
typedef struct TEB {

  dword                   EnvironmentPointer;
  dword                   ProcessId;
  dword                   threadId;
  dword                   ActiveRpcInfo;
  dword                   ThreadLocalStoragePointer;
  PEB*                    Peb;
  dword                   LastErrorValue;
  dword                   CountOfOwnedCriticalSections;
  dword                   CsrClientThread;
  dword                   Win32ThreadInfo;
  dword                   Win32ClientInfo[0x1F];
  dword                   WOW32Reserved;
  dword                   CurrentLocale;
  dword                   FpSoftwareStatusRegister;
  dword                   SystemReserved1[0x36];
  dword                   Spare1;
  dword                   ExceptionCode;
  dword                   SpareBytes1[0x28];
  dword                   SystemReserved2[0xA];
  dword                   GdiRgn;
  dword                   GdiPen;
  dword                   GdiBrush;
  dword                   RealClientId1;
  dword                   RealClientId2;
  dword                   GdiCachedProcessHandle;
  dword                   GdiClientPID;
  dword                   GdiClientTID;
  dword                   GdiThreadLocaleInfo;
  dword                   UserReserved[5];
  dword                   GlDispatchTable[0x118];
  dword                   GlReserved1[0x1A];
  dword                   GlReserved2;
  dword                   GlSectionInfo;
  dword                   GlSection;
  dword                   GlTable;
  dword                   GlCurrentRC;
  dword                   GlContext;
  dword                   LastStatusValue;
  char*                   StaticUnicodeString;
  char                    StaticUnicodeBuffer[0x105];
  dword                   DeallocationStack;
  dword                   TlsSlots[0x40];
  dword                   TlsLinks;
  dword                   Vdm;
  dword                   ReservedForNtRpc;
  dword                   DbgSsReserved[0x2];
  dword                   HardErrorDisabled;
  dword                   Instrumentation[0x10];
  dword                   WinSockData;
  dword                   GdiBatchCount;
  dword                   Spare2;
  dword                   Spare3;
  dword                   Spare4;
  dword                   ReservedForOle;
  dword                   WaitingOnLoaderLock;
  dword                   StackCommit;
  dword                   StackCommitMax;
  dword                   StackReserved;
};

typedef struct __LIST_ENTRY{
        dword              Flink;        // Ptr32 _LIST_ENTRY
        dword              Blink;       // Ptr32 _LIST_ENTRY
};
typedef struct _LDR_DATA_TABLE_ENTRY{
  __LIST_ENTRY               InLoadOrderLinks;
  __LIST_ENTRY               InMemoryOrderLinks;
  __LIST_ENTRY               InInitializationOrderLinks;
  dword                     DllBase;
  dword                     EntryPoint;
  dword                     SizeOfImage;
  char*                     FullDllName; // _UNICODE_STRING
  char*                     BaseDllName; //_UNICODE_STRING
  dword                     Flags;
  short                     LoadCount;
  short                     TlsIndex;
  union{
  __LIST_ENTRY               HashLinks;
  dword                     SectionPointer;
  };
  dword                     CheckSum;
  union{
    dword                   TimeDateStamp;
    dword                   LoadedImports;
  };
  dword                     EntryPointActivationContext;
  dword                     PatchInformation;
  __LIST_ENTRY               ForwarderLinks;
  __LIST_ENTRY               ServiceTagLinks;
  __LIST_ENTRY               StaticLinks;
};

typedef struct _PEB_LDR_DATA {
    dword                 Length_;
    dword                 Initialized;
    dword                 SsHandle;
    __LIST_ENTRY           InLoadOrderModuleList;
    __LIST_ENTRY           InMemoryOrderModuleList;
    __LIST_ENTRY           InInitializationOrderModuleList;
    dword                 EntryInProgress;
    dword                 ShutdownInProgress;
    dword                 ShutdownThreadId;
};

typedef struct PEB {
  char                    InheritedAddressSpace;
  char                    ReadImageFileExecOptions;
  char                    BeingDebugged;
  char                    Spare;
  dword                   Mutant;
  dword                   ImageBaseAddress;
  _PEB_LDR_DATA*           LoaderData;
  dword                   ProcessParameters;
  dword                   SubSystemData;
  dword                   ProcessHeap;
  dword                   FastPebLock;
  dword                   FastPebLockRoutine;
  dword                   FastPebUnlockRoutine;
  dword                   EnvironmentUpdateCount;
  dword                   KernelCallbackTable;
  dword                   EventLogSection;
  dword                   EventLog;
  dword                   FreeList;
  dword                   TlsExpansionCounter;
  dword                   TlsBitmap;
  dword                   TlsBitmapBits[0x2];
  dword                   ReadOnlySharedMemoryBase;
  dword                   ReadOnlySharedMemoryHeap;
  dword                   ReadOnlyStaticServerData;
  dword                   AnsiCodePageData;
  dword                   OemCodePageData;
  dword                   UnicodeCaseTableData;
  dword                   NumberOfProcessors;
  dword                   NtGlobalFlag;
  char                    Spare2[0x4];
  dword                   CriticalSectionTimeout1;
  dword                   CriticalSectionTimeout2;
  dword                   HeapSegmentReserve;
  dword                   HeapSegmentCommit;
  dword                   HeapDeCommitTotalFreeThreshold;
  dword                   HeapDeCommitFreeBlockThreshold;
  dword                   NumberOfHeaps;
  dword                   MaximumNumberOfHeaps;
  dword                   *ProcessHeaps;
  dword                   GdiSharedHandleTable;
  dword                   ProcessStarterHelper;
  dword                   GdiDCAttributeList;
  dword                   LoaderLock;
  dword                   OSMajorVersion;
  dword                   OSMinorVersion;
  dword                   OSBuildNumber;
  dword                   OSPlatformId;
  dword                   ImageSubSystem;
  dword                   ImageSubSystemMajorVersion;
  dword                   ImageSubSystemMinorVersion;
  dword                   GdiHandleBuffer[0x22];
  dword                   PostProcessInitRoutine;
  dword                   TlsExpansionBitmap;
  char                    TlsExpansionBitmapBits[0x80];
  dword                   SessionId;
};
